/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.GroupBox;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.JComponent;

public class FontChooserPanel
extends JComponent
implements Serializable,
KeyListener,
ItemListener {
    Checkbox italicBox;
    Checkbox boldBox;
    Label previewField;
    TextField sizeField;
    List nameList;
    GroupBox groupBox1;
    XYLayout xYLayout2;
    XYLayout xYLayout1 = new XYLayout();
    boolean changed;
    Font font;

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 8;
        dimension.height += 8;
        return dimension;
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.itemStateChanged(null);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.nameList.getSelectedItem();
        this.sizeField.setEnabled(true);
        this.boldBox.setEnabled(true);
        this.italicBox.setEnabled(true);
        Font font = new Font(string != null ? string : "Dialog", (this.boldBox.getState() ? 1 : 0) + (this.italicBox.getState() ? 2 : 0), this.getFontSize());
        this.changeFont(font, itemEvent != null && itemEvent.getSource() instanceof List, false);
    }

    int getFontSize() {
        try {
            int n = Integer.parseInt(this.sizeField.getText());
            if (n > 30000) {
                this.sizeField.setText(String.valueOf(30000));
            }
            int n2 = n < 30000 ? n : 30000;
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    protected void changeFont(Font font, boolean bl, boolean bl2) {
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (font == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = toolkit.getFontList();
        if (!bl && stringArray != null && this.nameList != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(font.getName())) continue;
                this.nameList.select(i);
                break;
            }
        }
        if (this.boldBox != null) {
            this.boldBox.setState(font.isBold());
        }
        if (this.italicBox != null) {
            this.italicBox.setState(font.isItalic());
        }
        this.previewField.setFont(font);
        this.fontChanged(font);
    }

    protected void changeFont(Font font) {
        this.changeFont(font, false, false);
    }

    protected void fontChanged(Font font) {
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setFontValue(Font font) {
        if (font != null) {
            this.sizeField.setText(Integer.toString(font.getSize()));
            this.changeFont(font);
        } else {
            this.sizeField.setText("12");
            this.nameList.select(-1);
        }
        this.sizeField.setEnabled(font != null);
        this.boldBox.setEnabled(font != null);
        this.italicBox.setEnabled(font != null);
        this.changed = false;
    }

    public Font getFontValue() {
        return this.font;
    }

    void init() {
        this.setLayout(this.xYLayout1);
        this.boldBox.setLabel(Res.getString(13));
        this.italicBox.setLabel(Res.getString(14));
        this.groupBox1.setLabel(Res.getString(16));
        this.previewField.setText(Res.getString(15));
        this.add((Component)this.nameList, new XYConstraints(13, 13, 158, 98));
        this.add((Component)this.boldBox, new XYConstraints(190, 14, 115, 20));
        this.add((Component)this.italicBox, new XYConstraints(190, 37, 115, 20));
        this.add((Component)this.groupBox1, new XYConstraints(182, 61, 110, 55));
        this.groupBox1.setLayout(new BorderLayout());
        this.groupBox1.add(this.sizeField);
        this.add((Component)this.previewField, new XYConstraints(11, 125, 278, 45));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = toolkit.getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.nameList.addItem(stringArray[i]);
        }
        this.nameList.addItemListener(this);
        this.boldBox.addItemListener(this);
        this.italicBox.addItemListener(this);
        this.sizeField.addKeyListener(this);
    }

    public void addNotify() {
        super.addNotify();
        ButtonDialog buttonDialog = this.findButtonDialog();
        if (buttonDialog != null) {
            buttonDialog.setEnterOK(true);
            buttonDialog.setEscapeCancel(true);
        }
    }

    ButtonDialog findButtonDialog() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ButtonDialog); container = container.getParent()) {
        }
        if (container instanceof ButtonDialog) {
            return (ButtonDialog)container;
        }
        return null;
    }

    public FontChooserPanel(Font font) {
        this();
        this.setFontValue(font);
    }

    public FontChooserPanel() {
        this.xYLayout2 = new XYLayout();
        this.groupBox1 = new GroupBox();
        this.nameList = new List();
        this.sizeField = new TextField();
        this.previewField = new Label();
        this.boldBox = new Checkbox();
        this.italicBox = new Checkbox();
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

