/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Filer
implements Serializable,
WindowListener {
    protected transient FilenameFilter filter;
    protected String dir;
    protected String file;
    protected int mode;
    protected String title;
    protected Frame frame;
    protected FileDialog dialog;
    public static final int SAVE = 1;
    public static final int LOAD = 0;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof FilenameFilter) {
            this.filter = (FilenameFilter)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.filter instanceof Serializable ? this.filter : null);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.dialog != null) {
            this.getFile();
            this.getDirectory();
            this.getFilenameFilter();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.getFile();
        this.getDirectory();
        this.getFilenameFilter();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res.getString(73));
                }
                this.dialog = new FileDialog(this.frame, this.title, this.mode);
                this.dialog.setFile(this.file);
                this.dialog.setDirectory(this.dir);
                this.dialog.setFilenameFilter(this.filter);
                this.dialog.addWindowListener(this);
            }
            this.dialog.show();
        } else if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public FilenameFilter getFilenameFilter() {
        if (this.dialog != null) {
            this.filter = this.dialog.getFilenameFilter();
        }
        return this.filter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        if (this.dialog != null) {
            this.dialog.setFilenameFilter(filenameFilter);
        }
    }

    public String getFile() {
        if (this.dialog != null) {
            this.file = this.dialog.getFile();
        }
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
        if (this.dialog != null) {
            this.dialog.setFile(string);
        }
    }

    public String getDirectory() {
        if (this.dialog != null) {
            this.dir = this.dialog.getDirectory();
        }
        return this.dir;
    }

    public void setDirectory(String string) {
        this.dir = string;
        if (this.dialog != null) {
            this.dialog.setDirectory(string);
        }
    }

    public int getMode() {
        if (this.dialog != null) {
            this.mode = this.dialog.getMode();
        }
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
        if (this.dialog != null) {
            this.dialog.setMode(n);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dialog != null) {
            ((Dialog)this.dialog).setTitle(string);
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Filer() {
        this(null, "", 0);
    }

    public Filer(Frame frame) {
        this(frame, "", 0);
    }

    public Filer(Frame frame, String string) {
        this(frame, string, 0);
    }

    public Filer(Frame frame, String string, int n) {
        this.frame = frame;
        this.title = string;
        this.mode = n;
        if (frame != null) {
            this.dialog = new FileDialog(frame, string, n);
        }
    }
}

