/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.view.CheckboxView;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class CheckboxControl
extends CheckboxView
implements Serializable,
ColumnAware,
BlackBox,
WritableSingletonModel,
AccessListener {
    private boolean addNotifyCalled = false;
    private String columnName;
    private DataSet dataSet;

    public void enableModelEvents(boolean bl) {
        this.getWriteModel().enableModelEvents(bl);
    }

    public void touched() {
        this.getWriteModel().touched();
    }

    public void set(Object object) {
        if (!this.isReadOnly()) {
            this.getWriteModel().set(object);
        }
    }

    public boolean canSet(boolean bl) {
        return this.isReadOnly() ? false : this.getWriteModel().canSet(bl);
    }

    public Object get() {
        return this.getModel().get();
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)dataSetException));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public boolean isChecked() {
        Object object = this.get();
        if (object instanceof Variant) {
            return ((Variant)object).getAsBoolean();
        }
        return super.isChecked();
    }

    public void setChecked(boolean bl) {
        boolean bl2;
        if (!this.isReadOnly() && (bl2 = this.isChecked()) != bl) {
            Object object = this.get();
            if (object instanceof Variant) {
                switch (((Variant)object).getType()) {
                    case 11: {
                        ((Variant)object).setBoolean(bl);
                        this.set(object);
                        break;
                    }
                    case 16: {
                        ((Variant)object).setString(String.valueOf(bl));
                        this.set(object);
                        break;
                    }
                    case 2: {
                        ((Variant)object).setByte((byte)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                    case 3: {
                        ((Variant)object).setShort((short)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                    case 4: {
                        ((Variant)object).setInt(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                    case 5: {
                        ((Variant)object).setLong((long)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                    case 6: {
                        ((Variant)object).setFloat((float)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                    case 7: {
                        ((Variant)object).setDouble((double)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                }
            } else {
                super.setChecked(bl);
            }
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(singletonModel);
    }

    public CheckboxControl() {
        this.setModel(new BasicSingletonContainer());
    }
}

