/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonControl;
import com.borland.jbcl.control.ButtonDescriptor;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import com.objectspace.jgl.Array;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ButtonDialog
extends JDialog
implements Serializable,
KeyListener,
ActionListener {
    protected Hashtable listeningTo = new Hashtable();
    protected Component centerPanel;
    protected ButtonDescriptor result;
    protected int buttonAlignment = 1;
    protected JPanel buttonPanelHolder;
    protected String[] labels;
    protected ButtonDescriptor[] buttonDescriptors;
    protected boolean escapeCancel = true;
    protected boolean enterOK = true;
    protected boolean centered = true;
    protected int buttonSet;
    protected transient ActionMulticaster actionMulticaster;
    protected Container buttonPanel;
    public static final int ALL = 1023;
    public static final int APPLY_DONE = 80;
    public static final int OK_CANCEL_APPLY = 73;
    public static final int YES_NO_CANCEL = 14;
    public static final int YES_NO = 6;
    public static final int OK_CANCEL = 9;
    public static final int DETAILS = 512;
    public static final int PREVIOUS = 256;
    public static final int NEXT = 128;
    public static final int APPLY = 64;
    public static final int HELP = 32;
    public static final int DONE = 16;
    public static final int CANCEL = 8;
    public static final int NO = 4;
    public static final int YES = 2;
    public static final int OK = 1;
    public static final int NONE = 0;
    public static final String DETAILS_COMMAND = "details";
    public static final String PREVIOUS_COMMAND = "previous";
    public static final String NEXT_COMMAND = "next";
    public static final String APPLY_COMMAND = "apply";
    public static final String HELP_COMMAND = "help";
    public static final String DONE_COMMAND = "done";
    public static final String CANCEL_COMMAND = "cancel";
    public static final String NO_COMMAND = "no";
    public static final String YES_COMMAND = "yes";
    public static final String OK_COMMAND = "ok";
    public static final String NONE_COMMAND = "none";

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27 && this.escapeCancel && (keyEvent.getModifiers() & (1 | 2 | 8)) == 0) {
            this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, CANCEL_COMMAND));
        } else if (keyEvent.getKeyCode() == 10 && (keyEvent.getModifiers() & (1 | 8)) == 0) {
            boolean bl;
            boolean bl2 = (keyEvent.getModifiers() & 2) != 0;
            boolean bl3 = bl = !this.enterOK || keyEvent.getSource() instanceof TextArea;
            if (bl2 == bl) {
                this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, OK_COMMAND));
            }
        } else if (keyEvent.getKeyCode() == 112 && (keyEvent.getModifiers() & (1 | 2 | 8)) == 0) {
            this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, HELP_COMMAND));
        }
    }

    public void dispose() {
        this.getContentPane().removeAll();
        if (this.centerPanel != null) {
            this.dropKeyListeners(this.centerPanel);
            this.centerPanel = null;
        }
        if (this.buttonDescriptors != null) {
            for (int i = 0; i < this.buttonDescriptors.length; ++i) {
                this.buttonDescriptors[i].button.removeActionListener(this);
            }
        }
        super.dispose();
    }

    protected void listenForKeys(Component component) {
        if (this.listeningTo.get(component) == null) {
            component.addKeyListener(this);
            this.listeningTo.put(component, component);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.listenForKeys(container.getComponent(i));
            }
        }
    }

    protected void dropKeyListeners(Component component) {
        Enumeration enumeration = this.listeningTo.elements();
        while (enumeration.hasMoreElements()) {
            Component component2 = (Component)enumeration.nextElement();
            component2.removeKeyListener(this);
        }
        this.listeningTo = new Hashtable();
    }

    protected void assureOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        if (rectangle.x + rectangle.width > dimension.width || rectangle.y + rectangle.height > dimension.height) {
            if (rectangle.x + rectangle.width > dimension.width) {
                rectangle.x -= rectangle.x + rectangle.width - dimension.width;
            }
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y -= rectangle.y + rectangle.height - dimension.height;
            }
            ((Component)this).setLocation(rectangle.x, rectangle.y);
        }
    }

    protected void centerOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, CANCEL_COMMAND));
        } else if (windowEvent.getID() == 200 && this.getComponentCount() > 0) {
            this.getComponent(this.getComponentCount() - 1).transferFocus();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processActionEvent(actionEvent);
    }

    public void show() {
        this.result = null;
        if (this.centered) {
            this.centerOnScreen();
        } else {
            this.assureOnScreen();
        }
        super.show();
    }

    public void enableButton(String string, boolean bl) {
        ButtonDescriptor buttonDescriptor = this.buttonFromCommand(string);
        if (buttonDescriptor != null) {
            buttonDescriptor.button.setEnabled(bl);
        }
    }

    public ButtonDescriptor buttonFromCommand(String string) {
        for (int i = 0; i < this.buttonDescriptors.length; ++i) {
            if (!this.buttonDescriptors[i].command.equals(string)) continue;
            return this.buttonDescriptors[i];
        }
        return null;
    }

    public ButtonDescriptor buttonFromID(int n) {
        for (int i = 0; i < this.buttonDescriptors.length; ++i) {
            if (this.buttonDescriptors[i].id != n) continue;
            return this.buttonDescriptors[i];
        }
        return null;
    }

    public int getResult() {
        return this.result != null ? this.result.getID() : 0;
    }

    public void setResult(int n) {
        this.result = this.buttonFromID(n);
    }

    public String[] getLabels() {
        return this.labels;
    }

    protected void setupButtonLabels() {
        if (this.labels.length == this.buttonDescriptors.length) {
            for (int i = 0; i < this.labels.length; ++i) {
                this.buttonDescriptors[i].button.setLabel(this.labels[i]);
            }
        } else {
            for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                ((Button)this.buttonPanel.getComponent(i)).setLabel(this.labels[i]);
            }
        }
    }

    private void setDefaultLabels() {
        this.labels = new String[this.buttonDescriptors.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = this.buttonDescriptors[i].label;
        }
    }

    public void setLabels(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < this.labels.length && i < stringArray.length; ++i) {
                this.labels[i] = stringArray[i];
            }
        } else {
            this.setDefaultLabels();
        }
        this.setupButtonLabels();
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        block4: {
            this.result = this.buttonFromCommand(actionEvent.getActionCommand());
            if (this.actionMulticaster != null) {
                try {
                    this.actionMulticaster.dispatch(actionEvent);
                }
                catch (Exception exception) {
                    if (this.result == null || !this.result.closeDialog) break block4;
                    return;
                }
            }
        }
        if (this.result != null && this.result.closeDialog || actionEvent.getActionCommand().equals(CANCEL_COMMAND)) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(actionListener);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(actionListener);
    }

    public int getButtonAlignment() {
        return this.buttonAlignment;
    }

    public void setButtonAlignment(int n) {
        if (n == this.buttonAlignment || this.buttonPanelHolder == null) {
            return;
        }
        FlowLayout flowLayout = (FlowLayout)this.buttonPanelHolder.getLayout();
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        flowLayout.setAlignment(n);
        this.buttonAlignment = n;
        this.invalidate();
        this.repaint(100L);
    }

    public boolean isEscapeCancel() {
        return this.escapeCancel;
    }

    public void setEscapeCancel(boolean bl) {
        this.escapeCancel = bl;
    }

    public boolean isEnterOK() {
        return this.enterOK;
    }

    public void setEnterOK(boolean bl) {
        this.enterOK = bl;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
    }

    public int getButtonSet() {
        return this.buttonSet;
    }

    private void setButtonSet(ButtonDescriptor[] buttonDescriptorArray) {
        int n;
        if (this.buttonDescriptors != null) {
            for (n = 0; n < this.buttonDescriptors.length; ++n) {
                this.buttonDescriptors[n].button.removeActionListener(this);
            }
        }
        this.buttonDescriptors = buttonDescriptorArray;
        this.buttonPanel.removeAll();
        for (n = 0; n < buttonDescriptorArray.length; ++n) {
            ButtonControl buttonControl;
            buttonDescriptorArray[n].button = buttonControl = new ButtonControl();
            buttonControl.setActionCommand(buttonDescriptorArray[n].command);
            buttonControl.addActionListener(this);
            this.buttonPanel.add(buttonControl);
        }
        this.setDefaultLabels();
        this.setupButtonLabels();
    }

    public void setButtonSet(int n) {
        if ((n & 0xFFFFFC00) != 0) {
            throw new IllegalArgumentException(Res.format(33, new String[]{Integer.toString(n & 0xFFFFFC00)}));
        }
        if (n != this.buttonSet) {
            this.buttonSet = n;
            this.setButtonSet(ButtonDialog.buttonSetToButtonDescriptors(n));
        }
    }

    protected ButtonDialog(Frame frame) {
        this(frame, "", null, 1);
    }

    protected ButtonDialog(Frame frame, String string) {
        this(frame, string, null, 1);
    }

    public void setCenterPanel(Component component) {
        if (this.centerPanel != null) {
            this.dropKeyListeners(this);
        }
        this.centerPanel = component;
        if (this.centerPanel != null) {
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setBackground(SystemColor.control);
            this.getContentPane().add(this.centerPanel, "Center");
            if (this.buttonPanelHolder != null) {
                this.getContentPane().add((Component)this.buttonPanelHolder, "South");
            } else {
                this.getContentPane().add((Component)this.buttonPanel, "South");
            }
            this.listenForKeys(this);
            this.pack();
        }
    }

    public Component getCenterPanel() {
        return this.centerPanel;
    }

    public ButtonDialog(Frame frame, String string, Component component) {
        this(frame, string, component, 1);
    }

    protected ButtonDialog(Frame frame, String string, Component component, int n) {
        this(frame, string, true, component, null, ButtonDialog.buttonSetToButtonDescriptors(n));
    }

    protected ButtonDialog(Frame frame, String string, boolean bl, Component component, Container container, ButtonDescriptor[] buttonDescriptorArray) {
        super(frame, string, bl);
        this.buttonPanel = container;
        if (container == null) {
            this.buttonPanelHolder = new JPanel();
            this.buttonPanelHolder.setLayout(new FlowLayout(1));
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridLayout(1, 0, 6, 0));
            this.buttonPanelHolder.add(this.buttonPanel);
        }
        if (component != null) {
            this.getContentPane().setLayout(new BorderLayout());
            ((Component)this).setBackground(SystemColor.control);
            this.getContentPane().add(component, "Center");
            if (this.buttonPanelHolder != null) {
                this.getContentPane().add((Component)this.buttonPanelHolder, "South");
            } else {
                this.getContentPane().add((Component)this.buttonPanel, "South");
            }
        }
        this.buttonSet = -1;
        this.setButtonSet(buttonDescriptorArray);
        this.listenForKeys(this);
        this.enableEvents(64L);
        this.pack();
    }

    protected static final ButtonDescriptor[] buttonSetToButtonDescriptors(int n) {
        Array array = new Array();
        if ((n & 0x100) != 0) {
            array.add((Object)new ButtonDescriptor(PREVIOUS_COMMAND, Res.getString(11), 256, false));
        }
        if ((n & 0x80) != 0) {
            array.add((Object)new ButtonDescriptor(NEXT_COMMAND, Res.getString(10), 128, false));
        }
        if ((n & 0x200) != 0) {
            array.add((Object)new ButtonDescriptor(DETAILS_COMMAND, Res.getString(12), 512, false));
        }
        if ((n & 1) != 0) {
            array.add((Object)new ButtonDescriptor(OK_COMMAND, Res.getString(0), 1, true));
        }
        if ((n & 2) != 0) {
            array.add((Object)new ButtonDescriptor(YES_COMMAND, Res.getString(2), 2, true));
        }
        if ((n & 4) != 0) {
            array.add((Object)new ButtonDescriptor(NO_COMMAND, Res.getString(4), 4, true));
        }
        if ((n & 8) != 0) {
            array.add((Object)new ButtonDescriptor(CANCEL_COMMAND, Res.getString(6), 8, true));
        }
        if ((n & 0x10) != 0) {
            array.add((Object)new ButtonDescriptor(DONE_COMMAND, Res.getString(9), 16, true));
        }
        if ((n & 0x20) != 0) {
            array.add((Object)new ButtonDescriptor(HELP_COMMAND, Res.getString(7), 32, false));
        }
        if ((n & 0x40) != 0) {
            array.add((Object)new ButtonDescriptor(APPLY_COMMAND, Res.getString(8), 64, false));
        }
        Object[] objectArray = new ButtonDescriptor[array.size()];
        array.copyTo(objectArray);
        return objectArray;
    }
}

