/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.ButtonView;
import com.borland.jbcl.view.CompositeItemPainter;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import com.objectspace.jgl.Pair;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class ButtonControl
extends ButtonView
implements Serializable,
BlackBox {
    protected String textureName;
    protected String label;
    protected String imageName;
    protected URL url;
    protected boolean imageFirst = true;
    protected int orientation;
    protected transient Image image;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SerializableImage) {
            this.image = ((SerializableImage)object).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.image != null ? SerializableImage.create(this.image) : null);
    }

    private void setupPainters() {
        ImageItemPainter imageItemPainter = this.image != null ? new ImageItemPainter(this, this.getAlignment()) : null;
        FocusableItemPainter focusableItemPainter = new FocusableItemPainter(new TextItemPainter(this.getAlignment(), new Insets(1, 1, 1, 1)), false);
        Serializable serializable = null;
        Object object = null;
        if (this.image == null) {
            serializable = focusableItemPainter;
            object = this.label;
        } else if (this.image != null && this.label == null) {
            serializable = new FocusableItemPainter(imageItemPainter, false);
            object = this.image;
        } else if (this.image != null && this.label != null) {
            Serializable serializable2;
            Serializable serializable3;
            if (this.imageFirst) {
                serializable3 = imageItemPainter;
                serializable2 = focusableItemPainter;
                object = new Pair((Object)this.image, (Object)this.label);
            } else {
                serializable3 = focusableItemPainter;
                serializable2 = imageItemPainter;
                object = new Pair((Object)this.label, (Object)this.image);
            }
            serializable = new CompositeItemPainter((ItemPainter)((Object)serializable3), (ItemPainter)((Object)serializable2), this.orientation, this.getAlignment());
        }
        this.setViewManager(new BasicViewManager((ItemPainter)((Object)serializable), null));
        if (!this.isReadOnly()) {
            this.getWriteModel().set(object);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    protected void setImage(Image image, String string) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res.getString(70));
        }
        if (image != null) {
            this.prepareImage(image, this);
        }
        this.image = image;
        this.imageName = string;
        this.getWriteModel().set(this.image);
        this.setupPainters();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) {
        Image image = null;
        if (string != null) {
            ImageLoader.loadFromResource(string, this);
            if (image == null) {
                try {
                    image = ImageLoader.load(new URL(string), (Component)this);
                }
                catch (MalformedURLException malformedURLException) {
                    image = ImageLoader.load(string, (Component)this);
                }
            }
        }
        this.setImage(image, string);
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageURL(URL uRL) {
        this.url = uRL;
        this.setImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.setImage(image, "");
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.setupPainters();
        this.invalidate();
        this.repaint(50L);
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setImageFirst(boolean bl) {
        this.imageFirst = bl;
        this.setupPainters();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.setupPainters();
    }

    public ButtonControl(String string, Image image) {
        this();
        this.setLabel(string);
        this.setImage(image);
    }

    public ButtonControl(Image image) {
        this();
        this.setImage(image);
    }

    public ButtonControl(String string) {
        this();
        this.setLabel(string);
    }

    public ButtonControl() {
        this.setModel(new BasicSingletonContainer());
        this.setupPainters();
    }
}

