/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.ButtonControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.MouseMotionMulticaster;
import com.borland.jbcl.util.MouseMulticaster;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.BorderItemPainter;
import com.borland.jbcl.view.Spacer;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class ButtonBar
extends BevelPanel
implements Serializable,
BlackBox {
    protected boolean needsRebuild;
    protected BorderItemPainter border;
    protected transient MouseMotionMulticaster mouseMotionMulticaster;
    protected transient MouseMulticaster mouseMulticaster;
    protected transient ActionMulticaster actionMulticaster;
    private MediaTracker mt;
    private boolean[] visibleState;
    private boolean[] enabledState;
    private Array buttons;
    private String[] imageNames;
    private String[] labels = new String[0];
    private String imageBase;
    private boolean showRollover = false;
    private boolean imageFirst = true;
    private int buttonAlign = 34;
    private int buttonOrient = 1;
    private int buttonType = 3;
    private transient Image[] images;
    public static final int TEXT_AND_IMAGE = 3;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 1;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SerializableImage[]) {
            SerializableImage[] serializableImageArray = (SerializableImage[])object;
            this.images = new Image[serializableImageArray.length];
            for (int i = 0; i < serializableImageArray.length; ++i) {
                this.images[i] = serializableImageArray[i].getImage();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.images != null && this.images.length > 0) {
            SerializableImage[] serializableImageArray = new SerializableImage[this.images.length];
            for (int i = 0; i < this.images.length; ++i) {
                serializableImageArray[i] = SerializableImage.create(this.images[i]);
            }
            objectOutputStream.writeObject(serializableImageArray);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    protected Component addSpace(int n) {
        Spacer spacer = new Spacer(n);
        this.buttons.add((Object)spacer);
        this.repaint(100L);
        this.invalidate();
        return super.add(spacer);
    }

    protected Component addSpace() {
        this.invalidate();
        return this.addSpace(5);
    }

    protected Component addTextButton(String string, String string2) {
        ButtonControl buttonControl = new ButtonControl();
        buttonControl.setLabel(string);
        buttonControl.setActionCommand(string2);
        buttonControl.addActionListener(this.actionMulticaster);
        buttonControl.addMouseListener(this.mouseMulticaster);
        buttonControl.addMouseMotionListener(this.mouseMotionMulticaster);
        buttonControl.setFocusAware(false);
        buttonControl.setShowRollover(this.showRollover);
        buttonControl.setOrientation(this.buttonOrient);
        buttonControl.setAlignment(this.buttonAlign);
        buttonControl.setOpaque(this.isOpaque());
        buttonControl.setImageFirst(this.imageFirst);
        this.buttons.add((Object)buttonControl);
        this.invalidate();
        return this.add(buttonControl);
    }

    protected Component addImageButton(Image image, String string, String string2) {
        ButtonControl buttonControl = new ButtonControl(image);
        if (string != null) {
            buttonControl.setLabel(string);
        }
        buttonControl.setActionCommand(string2);
        buttonControl.addActionListener(this.actionMulticaster);
        buttonControl.addMouseListener(this.mouseMulticaster);
        buttonControl.addMouseMotionListener(this.mouseMotionMulticaster);
        buttonControl.setFocusAware(false);
        buttonControl.setShowRollover(this.showRollover);
        buttonControl.setOrientation(this.buttonOrient);
        buttonControl.setAlignment(this.buttonAlign);
        buttonControl.setOpaque(this.isOpaque());
        buttonControl.setImageFirst(this.imageFirst);
        this.buttons.add((Object)buttonControl);
        this.invalidate();
        return this.add(buttonControl);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.mouseMotionMulticaster.remove(mouseMotionListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.mouseMotionMulticaster.add(mouseMotionListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.mouseMulticaster.remove(mouseListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.mouseMulticaster.add(mouseListener);
    }

    public Dimension getPreferredSize() {
        this.rebuild();
        Dimension dimension = super.getPreferredSize();
        if (dimension.height == 150) {
            dimension.height = 32;
        }
        return dimension;
    }

    public void doLayout() {
        this.rebuild();
        super.doLayout();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.needsRebuild = true;
        this.doLayout();
    }

    protected void rebuild() {
        if (this.needsRebuild) {
            this.removeAll();
            this.assureImages();
            this.buttons.clear();
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != null && this.labels[i].length() > 0) {
                    if (this.buttonType == 1 || this.imageNames == null || i >= this.imageNames.length) {
                        this.addTextButton(this.labels[i], this.labels[i]);
                    } else if (this.buttonType == 3) {
                        this.addImageButton(this.images[i], this.labels[i], this.labels[i]);
                    } else {
                        this.addImageButton(this.images[i], null, this.labels[i]);
                    }
                    if (this.isEnabled()) {
                        ((ButtonControl)this.buttons.at(i)).setEnabled(this.enabledState[i]);
                    } else {
                        ((ButtonControl)this.buttons.at(i)).setEnabled(false);
                    }
                    ((ButtonControl)this.buttons.at(i)).setVisible(this.visibleState[i]);
                    continue;
                }
                this.addSpace();
            }
            this.needsRebuild = false;
        }
    }

    protected void assureImages() {
        if (this.mt != null) {
            try {
                this.mt.waitForAll(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mt = null;
        }
    }

    protected void invalidateImages() {
        if (this.images != null) {
            this.images = null;
        }
        if (this.imageNames.length > 0) {
            this.images = new Image[this.imageNames.length];
            this.mt = new MediaTracker(this);
            String string = this.imageBase;
            if (string != null && string.length() > 0 && !string.endsWith("/") && !string.endsWith(File.separator)) {
                string = String.valueOf(string).concat(String.valueOf("/"));
            }
            for (int i = 0; i < this.imageNames.length; ++i) {
                String string2 = string != null ? String.valueOf(string).concat(String.valueOf(this.imageNames[i])) : this.imageNames[i];
                this.images[i] = ImageLoader.loadFromResource(string2, this);
                if (this.images[i] != null) continue;
                try {
                    this.images[i] = ImageLoader.load(new URL(string2), (Component)this, true);
                }
                catch (MalformedURLException malformedURLException) {
                    this.images[i] = ImageLoader.load(string2, (Component)this, true);
                }
                if (this.images[i] == null) continue;
                this.mt.addImage(this.images[i], i);
            }
            this.mt.checkAll(true);
            try {
                this.mt.waitForAll(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void invalidateButtons() {
        this.needsRebuild = true;
        this.invalidate();
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionMulticaster.remove(actionListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionMulticaster.add(actionListener);
    }

    public boolean isButtonVisible(String string) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            return this.isButtonVisible(i);
        }
        return false;
    }

    public void setButtonVisible(String string, boolean bl) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            this.setButtonVisible(i, bl);
            return;
        }
    }

    public boolean isButtonEnabled(String string) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            return this.isButtonEnabled(i);
        }
        return false;
    }

    public void setButtonEnabled(String string, boolean bl) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            this.setButtonEnabled(i, bl);
            return;
        }
    }

    public boolean isButtonVisible(int n) {
        Object object;
        if (n < 0 || n >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            return ((ButtonControl)object).isVisible();
        }
        return false;
    }

    public void setButtonVisible(int n, boolean bl) {
        Object object;
        if (n < 0 || n >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            ((ButtonControl)object).setVisible(bl);
        }
        this.visibleState[n] = bl;
    }

    public boolean isButtonEnabled(int n) {
        Object object;
        if (n < 0 || n >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            return ((ButtonControl)object).isEnabled();
        }
        return false;
    }

    public void setButtonEnabled(int n, boolean bl) {
        Object object;
        if (n < 0 || n >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && this.isEnabled() && (object = this.buttons.at(n)) instanceof ButtonControl) {
            ((ButtonControl)object).setEnabled(bl);
        }
        this.enabledState[n] = bl;
    }

    public void setVgap(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setVgap(n);
        } else if (layoutManager instanceof GridLayout) {
            ((GridLayout)layoutManager).setVgap(n);
        }
    }

    public int getVgap() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getVgap();
        }
        if (layoutManager instanceof GridLayout) {
            return ((GridLayout)layoutManager).getVgap();
        }
        return 0;
    }

    public void setHgap(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setHgap(n);
        } else if (layoutManager instanceof GridLayout) {
            ((GridLayout)layoutManager).setHgap(n);
        }
    }

    public int getHgap() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getHgap();
        }
        if (layoutManager instanceof GridLayout) {
            return ((GridLayout)layoutManager).getHgap();
        }
        return 0;
    }

    public void setAlignment(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setAlignment(n);
        }
    }

    public int getAlignment() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getAlignment();
        }
        return 0;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setShowRollover(bl);
        }
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setImageFirst(boolean bl) {
        this.imageFirst = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setImageFirst(this.imageFirst);
        }
    }

    public int getButtonAlignment() {
        return this.buttonAlign;
    }

    public void setButtonAlignment(int n) {
        this.buttonAlign = n;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setAlignment(this.buttonAlign);
            this.getComponent(i).invalidate();
        }
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setOpaque(bl);
        }
    }

    public int getButtonOrientation() {
        return this.buttonOrient;
    }

    public void setButtonOrientation(int n) {
        this.buttonOrient = n;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setOrientation(this.buttonOrient);
            this.getComponent(i).invalidate();
        }
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(int n) {
        if (n == 1 || n == 2 || n == 3) {
            if (n != this.buttonType) {
                this.buttonType = n;
                this.invalidateButtons();
            }
        } else {
            throw new IllegalArgumentException(Res.format(34, String.valueOf(n)));
        }
    }

    public String[] getImageNames() {
        String[] stringArray = new String[this.imageNames.length];
        System.arraycopy(this.imageNames, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setImageNames(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            this.imageNames = stringArray2;
            if (this.buttonType == 2 || this.buttonType == 3) {
                this.invalidateImages();
                this.invalidateButtons();
            }
        }
    }

    public String getImageBase() {
        return this.imageBase;
    }

    public void setImageBase(String string) {
        this.imageBase = string;
        if (this.buttonType == 2 || this.buttonType == 3) {
            this.invalidateImages();
            this.invalidateButtons();
        }
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.labels.length];
        System.arraycopy(this.labels, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setLabels(String[] stringArray) {
        int n;
        boolean[] blArray;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        if (stringArray.length != this.enabledState.length) {
            blArray = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                blArray[n] = true;
            }
            this.enabledState = blArray;
        }
        if (stringArray.length != this.visibleState.length) {
            blArray = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                blArray[n] = true;
            }
            this.visibleState = blArray;
        }
        this.labels = stringArray2;
        this.invalidateButtons();
    }

    public ButtonBar() {
        this.imageNames = new String[0];
        this.buttons = new Array();
        this.enabledState = new boolean[0];
        this.visibleState = new boolean[0];
        this.actionMulticaster = new ActionMulticaster();
        this.mouseMulticaster = new MouseMulticaster();
        this.mouseMotionMulticaster = new MouseMotionMulticaster();
        this.border = new BorderItemPainter(2);
        super.setLayout(new FlowLayout(0, 0, 0));
        super.setBackground(SystemColor.control);
        this.setMargins(new Insets(2, 2, 2, 2));
    }
}

