/*
 * Decompiled with CFR 0.152.
 */
package Dialogos;

import Dialogos.AreaDeDibujo;
import Dialogos.VentanaArbolAscendente_bCerrar_actionAdapter;
import Dialogos.arcoArbolAscendente;
import Dialogos.nodoArbolAscendente;
import Dialogos.nodoArcoAscendente;
import Dialogos.vectorDesplazamiento;
import gramatica.Gramatica;
import gramatica.Simbolo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import servicios.DatoSistema;
import servicios.GestorLiterales;

public class VentanaArbolAscendente
extends JFrame {
    public static final int DIRECTO = 0;
    public static final int PASOS = 1;
    public static final float SEPARACION_NIVELES = 50.0f;
    private int maxAltura = 70;
    Vector nodosPendientes = new Vector();
    Vector nodosDesplazar = new Vector();
    int tipoSimulacion;
    float posXNodo = 10.0f;
    Gramatica g;
    boolean cerrado = false;
    JScrollPane jScrollPane1 = new JScrollPane();
    AreaDeDibujo miCanvas = new AreaDeDibujo(0);
    Vector vectorNodos = new Vector();
    Vector vectorArcos = new Vector();
    JPanel jPanel1 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton bCerrar = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GestorLiterales gesLit = (GestorLiterales)DatoSistema.darDato("GESTOR_LITERALES");

    public VentanaArbolAscendente(Gramatica g, int tipo) {
        try {
            this.tipoSimulacion = tipo;
            this.g = g;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ((Component)this).setSize(300, 300);
        this.setTitle(this.gesLit.darLiteral("tituloArbol"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        ((Component)this).setBackground(Color.white);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.miCanvas.setEditable(false);
        this.jPanel1.setLayout(this.flowLayout1);
        this.bCerrar.setBackground(Color.lightGray);
        this.bCerrar.setText(String.valueOf(String.valueOf(new StringBuffer(" ").append(this.gesLit.darLiteral("submenuCerrar")).append(" "))));
        this.bCerrar.addActionListener(new VentanaArbolAscendente_bCerrar_actionAdapter(this));
        this.jPanel1.setBackground(Color.lightGray);
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 388, 214));
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 307, -1));
        this.jPanel1.add((Component)this.bCerrar, null);
        this.jScrollPane1.getViewport().add((Component)this.miCanvas, null);
    }

    public void anyadeHermano(Simbolo simbolo) {
        if (!this.cerrado) {
            nodoArbolAscendente hermano = this.g.estaNoTerminal(simbolo) ? this.dibujaNoTerminal(this.posXNodo, 15.0f, simbolo.toString()) : this.dibujaTerminal(this.posXNodo, 15.0f, simbolo.toString());
            this.nodosPendientes.addElement(hermano);
            this.posXNodo += hermano.dameSeparacion();
            this.vectorNodos.addElement(hermano);
            if (this.tipoSimulacion == 1) {
                this.miCanvas.actualizaDibujo(this.vectorNodos, this.vectorArcos, (int)this.posXNodo, this.maxAltura);
            }
        }
    }

    public void reduce(Simbolo simbolo, int numElementos) {
        if (!this.cerrado) {
            float yInt;
            this.nodosDesplazar = new vectorDesplazamiento();
            int i = this.nodosPendientes.size() - numElementos;
            while (i < this.nodosPendientes.size()) {
                nodoArbolAscendente aux = (nodoArbolAscendente)this.nodosPendientes.elementAt(i);
                this.nodosPendientes.removeElementAt(i);
                this.nodosDesplazar.addElement(aux);
            }
            int aux = this.desplazarNodos();
            if (aux > this.maxAltura) {
                this.maxAltura = aux;
            }
            nodoArbolAscendente primerHijo = (nodoArbolAscendente)this.nodosDesplazar.elementAt(0);
            nodoArbolAscendente padre = this.g.estaNoTerminal(simbolo) ? this.dibujaNoTerminal(primerHijo.dameX(), 15.0f, simbolo.toString()) : this.dibujaTerminal(primerHijo.dameX(), 15.0f, simbolo.toString());
            float xInt = primerHijo.dameX() + primerHijo.dameAncho() / (float)2;
            if (xInt > padre.dameX() + padre.dameAlto()) {
                xInt = padre.dameX() + padre.dameAncho() / (float)2;
                yInt = padre.dameAlto() + padre.dameY();
            } else {
                yInt = this.obtenerInterseccionY(padre, xInt);
            }
            for (int i2 = 0; i2 < this.nodosDesplazar.size(); ++i2) {
                nodoArbolAscendente nodoHijo = (nodoArbolAscendente)this.nodosDesplazar.elementAt(i2);
                arcoArbolAscendente arcoUnion = new arcoArbolAscendente(xInt, yInt, nodoHijo.dameX() + nodoHijo.dameAncho() / (float)2, nodoHijo.dameY());
                nodoArcoAscendente nodoarco = new nodoArcoAscendente(nodoHijo, arcoUnion);
                padre.ponerHijo(nodoarco);
                this.vectorArcos.addElement(arcoUnion);
            }
            this.vectorNodos.addElement(padre);
            this.nodosPendientes.addElement(padre);
            if (this.tipoSimulacion == 1) {
                this.miCanvas.actualizaDibujo(this.vectorNodos, this.vectorArcos, (int)this.posXNodo, this.maxAltura);
            }
        }
    }

    private float obtenerInterseccionY(nodoArbolAscendente nodo, float posX) {
        float res = nodo.dameY() + nodo.dameAlto();
        Ellipse2D.Float figura = nodo.dameFigura();
        while (!figura.contains(posX, res)) {
            res -= 0.1f;
        }
        return res;
    }

    private int desplazarNodos() {
        int maxY = 0;
        for (int i = 1; i <= this.nodosDesplazar.size(); ++i) {
            nodoArbolAscendente nodo = (nodoArbolAscendente)this.nodosDesplazar.elementAt(i - 1);
            Ellipse2D.Float elipse = nodo.dameFigura();
            nodo.desplazar(50.0f);
            maxY = (int)(nodo.dameY() + nodo.dameAlto());
            Vector hijos = nodo.dameHijos();
            for (int j = 0; j < hijos.size(); ++j) {
                nodoArcoAscendente nodoarco = (nodoArcoAscendente)hijos.elementAt(j);
                int aux = this.desplazarHijo(nodoarco);
                if (aux <= maxY) continue;
                maxY = aux;
            }
        }
        return maxY;
    }

    private int desplazarHijo(nodoArcoAscendente hijo) {
        int maxY = 0;
        nodoArbolAscendente nodoHijo = hijo.nodo;
        arcoArbolAscendente arcoHijo = hijo.arco;
        nodoHijo.desplazar(50.0f);
        maxY = (int)(nodoHijo.dameY() + nodoHijo.dameAlto());
        Line2D.Float linea = arcoHijo.dameFigura();
        linea.setLine(arcoHijo.dameX1(), arcoHijo.dameY1() + 50.0f, arcoHijo.dameX2(), arcoHijo.dameY2() + 50.0f);
        Vector hijos = nodoHijo.dameHijos();
        for (int i = 0; i < hijos.size(); ++i) {
            nodoArcoAscendente nodoarco = (nodoArcoAscendente)hijos.elementAt(i);
            int aux = this.desplazarHijo(nodoarco);
            if (aux <= maxY) continue;
            maxY = aux;
        }
        return maxY;
    }

    private nodoArbolAscendente dibujaTerminal(float posX, float posY, String simbolo) {
        Ellipse2D.Float terminal = new Ellipse2D.Float(posX, posY, 40.0f, 30.0f);
        return new nodoArbolAscendente(terminal, simbolo, 0);
    }

    private nodoArbolAscendente dibujaNoTerminal(float posX, float posY, String simbolo) {
        Ellipse2D.Float terminal = new Ellipse2D.Float(posX, posY, 40.0f, 30.0f);
        return new nodoArbolAscendente(terminal, simbolo, 1);
    }

    public void mostrarDirecto() {
        this.show();
        this.miCanvas.actualizaDibujo(this.vectorNodos, this.vectorArcos, (int)this.posXNodo, this.maxAltura);
    }

    void bCerrar_actionPerformed(ActionEvent e) {
        this.cerrado = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    static {
        DIRECTO = 0;
        PASOS = 1;
        SEPARACION_NIVELES = 50.0f;
    }
}

