/*
 * Decompiled with CFR 0.152.
 */
package Dialogos;

import Dialogos.arcoArbol;
import Dialogos.arcoArbolAscendente;
import Dialogos.nodoArbol;
import Dialogos.nodoArbolAscendente;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextArea;

public class AreaDeDibujo
extends JTextArea {
    public static final int ASCENDENTE = 0;
    public static final int DESCENDENTE = 1;
    BufferedImage grafico;
    Graphics2D imagen;
    Hashtable tablaNodos;
    Hashtable tablaArcos;
    Vector vectorNodos;
    Vector vectorArcos;
    int tipo;
    int ancho;
    int alto;
    String textoAncho = new String("WWWWWWWWWWWWWWWWWWWW");
    String textoAlto = new String("W\n\n\n\n\n\n\n\n\n");
    int numLineas = 10;

    public AreaDeDibujo(int tipo) {
        this.tipo = tipo;
        if (tipo == 1) {
            this.tablaNodos = new Hashtable();
            this.tablaArcos = new Hashtable();
        } else {
            this.vectorNodos = new Vector();
            this.vectorArcos = new Vector();
        }
        this.setText(this.textoAncho.concat(this.textoAlto));
    }

    public void paint(Graphics g) {
        Object n;
        Dimension d = this.getSize();
        this.grafico = (BufferedImage)this.createImage(d.width, d.height);
        this.imagen = this.grafico.createGraphics();
        this.imagen.setColor(Color.black);
        this.imagen.setStroke(new BasicStroke(1.0f));
        this.imagen.setBackground(this.getBackground());
        if (this.tipo == 1) {
            Enumeration nodos = this.tablaNodos.elements();
            while (nodos.hasMoreElements()) {
                n = (nodoArbol)nodos.nextElement();
                this.imagen.setPaint(((nodoArbol)n).dameColor());
                this.imagen.fill(((nodoArbol)n).dameFigura());
                this.imagen.setPaint(Color.black);
                this.imagen.drawString(((nodoArbol)n).dameTexto(), ((nodoArbol)n).dameX() + (float)10, ((nodoArbol)n).dameY() + (float)((double)((nodoArbol)n).dameAlto() * 0.66));
            }
            Enumeration arcos = this.tablaArcos.elements();
            while (arcos.hasMoreElements()) {
                arcoArbol a = (arcoArbol)arcos.nextElement();
                this.imagen.draw(a.dameFigura());
            }
        } else {
            int i;
            for (i = 0; i < this.vectorNodos.size(); ++i) {
                n = (nodoArbolAscendente)this.vectorNodos.elementAt(i);
                this.imagen.setPaint(((nodoArbolAscendente)n).dameColor());
                this.imagen.fill(((nodoArbolAscendente)n).dameFigura());
                this.imagen.setPaint(Color.black);
                this.imagen.drawString(((nodoArbolAscendente)n).dameTexto(), ((nodoArbolAscendente)n).dameX() + (float)10, ((nodoArbolAscendente)n).dameY() + (float)((double)((nodoArbolAscendente)n).dameAlto() * 0.66));
            }
            for (i = 0; i < this.vectorArcos.size(); ++i) {
                arcoArbolAscendente a = (arcoArbolAscendente)this.vectorArcos.elementAt(i);
                this.imagen.draw(a.dameFigura());
            }
        }
        g.drawImage(this.grafico, 0, 0, null);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(g.getFont());
        int a = fm.stringWidth(this.textoAncho);
        boolean cambio = false;
        while (a < this.ancho) {
            this.textoAncho = this.textoAncho.concat("WW");
            a = fm.stringWidth(this.textoAncho);
            cambio = true;
        }
        int altoLinea = 15;
        int totalLineas = this.alto / altoLinea;
        while (totalLineas > this.numLineas) {
            this.textoAlto = this.textoAlto.concat("\n");
            ++this.numLineas;
            cambio = true;
        }
        if (cambio) {
            this.setText(this.textoAncho.concat(this.textoAlto));
        }
        this.getToolkit().sync();
    }

    public void actualizaDibujo(Hashtable tablaNodos, Hashtable tablaArcos, int ancho, int alto) {
        this.ancho = ancho;
        this.alto = alto;
        this.tablaArcos = tablaArcos;
        this.tablaNodos = tablaNodos;
        this.update(this.getGraphics());
    }

    public void actualizaDibujo(Vector vectorNodos, Vector vectorArcos, int ancho, int alto) {
        this.ancho = ancho;
        this.alto = alto;
        this.vectorArcos = vectorArcos;
        this.vectorNodos = vectorNodos;
        this.update(this.getGraphics());
    }

    static {
        ASCENDENTE = 0;
        DESCENDENTE = 1;
    }
}

