/*
 * Decompiled with CFR 0.152.
 */
package leapTools;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;

public class Minimizer
extends Task {
    private boolean verbose = false;
    private int removedCnt = 0;
    private String basedir;
    private String checkdir;

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setCheckdir(String string) {
        this.checkdir = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void execute() throws BuildException {
        block7: {
            try {
                if (this.basedir != null) {
                    this.basedir = this.getProject().getBaseDir().toString() + "/" + this.basedir;
                    File file = new File(this.basedir);
                    if (file.isDirectory()) {
                        if (this.checkdir != null) {
                            this.checkdir = this.getProject().getBaseDir().toString() + "/" + this.checkdir;
                            File file2 = new File(this.checkdir);
                            if (file2.isDirectory()) {
                                DirectoryScanner directoryScanner = new DirectoryScanner();
                                directoryScanner.setBasedir(file);
                                directoryScanner.setIncludes(new String[]{"**/*.class"});
                                directoryScanner.scan();
                                String[] stringArray = directoryScanner.getIncludedFiles();
                                System.out.println("Checking " + stringArray.length + " files.");
                                int n = 0;
                                while (n < stringArray.length) {
                                    this.check(stringArray[n], file, file2);
                                    ++n;
                                }
                                System.out.println("Removed  " + this.removedCnt + " un-necessary files.");
                                break block7;
                            }
                            throw new BuildException("Error: " + this.checkdir + " is not a directory.");
                        }
                        throw new BuildException("Error: checkdir not specified.");
                    }
                    throw new BuildException("Error: " + this.basedir + " is not a directory.");
                }
                throw new BuildException("Error: basedir not specified.");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new BuildException(throwable.getMessage());
            }
        }
    }

    private void check(String string, File file, File file2) throws Throwable {
        File file3;
        String string2 = file2.getPath() + "/" + string;
        if (this.verbose) {
            System.out.println("Checking file " + string2);
        }
        if (!(file3 = new File(string2)).exists()) {
            File file4;
            string2 = file.getPath() + "/" + string;
            if (this.verbose) {
                System.out.println("Removing file " + string2);
            }
            if (!(file4 = new File(string2)).delete()) {
                System.out.println("Can't delete file " + file4.getName());
                throw new BuildException("Can't delete file " + file4.getName());
            }
            ++this.removedCnt;
        }
    }
}

