/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JARSourceCopierTask
extends Task {
    private File m_jarFile;
    private File m_sourceDirectory;
    private File m_destinationDirectory;

    public void setJar(File file) {
        this.m_jarFile = file;
    }

    public void setSrc(File file) {
        this.m_sourceDirectory = file;
    }

    public void setDest(File file) {
        this.m_destinationDirectory = file;
    }

    public void execute() throws BuildException {
        if (this.m_jarFile == null || !this.m_jarFile.exists()) {
            throw new BuildException("Jar file not found (jar attribute): " + this.m_jarFile);
        }
        if (this.m_sourceDirectory == null || !this.m_sourceDirectory.exists()) {
            throw new BuildException("Source directory not found (src attribute): " + this.m_sourceDirectory);
        }
        if (this.m_destinationDirectory == null) {
            throw new BuildException("Destination directory not set (dest attribute)");
        }
        this.m_destinationDirectory.mkdirs();
        int n = 0;
        int n2 = 0;
        try {
            ZipFile zipFile = new ZipFile(this.m_jarFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                File file;
                Object object;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() && zipEntry.getName().indexOf("META-INF") == -1) {
                    object = new File(this.m_destinationDirectory, zipEntry.getName());
                    ((File)object).mkdirs();
                    ++n;
                    continue;
                }
                object = zipEntry.getName();
                if (!((String)object).endsWith(".class") || !(file = new File(this.m_sourceDirectory, string = ((String)object).substring(0, ((String)object).lastIndexOf(".")) + ".java")).exists()) continue;
                File file2 = new File(this.m_destinationDirectory, string);
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                int n3 = 0;
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n3);
                }
                fileInputStream.close();
                fileOutputStream.close();
                ++n2;
            }
        }
        catch (ZipException zipException) {
            throw new BuildException("Problem loading JAR file - " + zipException.getMessage());
        }
        catch (IOException iOException) {
            throw new BuildException("Problem loading JAR file - " + iOException.getMessage());
        }
        this.log(n + " directories created, " + n2 + " files copied");
    }
}

