/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;

public class PreverifyTask
extends Task {
    private File m_unverified;
    private File m_verified;
    private String m_classpath;

    public void setUnverified(File file) {
        this.m_unverified = file;
    }

    public void setVerified(File file) {
        this.m_verified = file;
    }

    public void setClasspath(String string) {
        this.m_classpath = string;
    }

    public void execute() throws BuildException {
        String string = this.project.getProperty("os.name").toLowerCase();
        String string2 = null;
        if (string.indexOf("windows") != -1) {
            string2 = "preverify.exe";
        } else if (string.indexOf("linux") != -1) {
            string2 = "preverify";
        } else {
            throw new BuildException("Preverify is only supported on Windows and Linux at this time", this.location);
        }
        String string3 = this.project.getProperty("j2mewtk.home");
        File file = new File(string3 + File.separator + "bin" + File.separator + string2);
        if (!file.isFile()) {
            throw new BuildException("Preverify executable not found, be sure that j2mewtk.home property is set correctly", this.location);
        }
        if (this.m_unverified == null) {
            throw new BuildException("unverified attribute must be set", this.location);
        }
        if (!this.m_unverified.isDirectory()) {
            throw new BuildException("unverified " + this.m_unverified + " does not exist or is not a directory", this.location);
        }
        if (this.m_verified == null) {
            throw new BuildException("verified attribute must be set", this.location);
        }
        if (!this.m_verified.isDirectory()) {
            throw new BuildException("verified " + this.m_verified + " does not exist or is not a directory", this.location);
        }
        try {
            Commandline commandline = new Commandline();
            commandline.setExecutable(file.getPath());
            String string4 = this.project.getProperty("boot-midp-classes");
            if (this.m_classpath != null) {
                string4 = string4 + File.pathSeparator + this.m_classpath;
            }
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setValue(string4);
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.m_verified);
            commandline.createArgument().setFile(this.m_unverified);
            this.log("Preverifying classes to " + this.m_verified);
            this.log("Executing: " + commandline, 3);
            Execute execute = new Execute();
            execute.setCommandline(commandline.getCommandline());
            execute.execute();
            if (execute.getExitValue() != 0) {
                throw new BuildException("Call to preverify failed");
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.location);
        }
    }
}

