/*
 * Decompiled with CFR 0.152.
 */
package leapTools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;

public class Package {
    static String defaultJar = "Client.jar";
    ClassPath classPath = new ClassPath();
    TreeMap allClasses = new TreeMap();
    TreeMap dependents = new TreeMap();
    TreeMap notFound = new TreeMap();
    boolean showNotFound = false;
    boolean printClasses = false;
    boolean log = false;

    public static void main(String[] stringArray) {
        Package package_ = new Package();
        try {
            package_.execute(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            package_.usage();
        }
    }

    public void usage() {
        System.out.println(" This program packages classes and all their dependents");
        System.out.println(" into one jar. Give all starting classes (your main)");
        System.out.println(" on the command line. Use / as separator, the .class is");
        System.out.println(" optional. We use the environments CLASSPATH to resolve");
        System.out.println(" classes. Anything but java.* packages are packaged.");
        System.out.println(" If you use Class.forName (or similar), be sure to");
        System.out.println(" include the classes that you load dynamically on the");
        System.out.println(" command line.\n");
        System.out.println(" Usage: java [JAVA_OPTIONS] leapTools.Package [OPTIONS] [CLASSES]\n");
        System.out.println(" These options are recognized:");
        System.out.println("  -d --dest [JAR]\t Specify the name of the jar containing");
        System.out.println("            \t\t the classes.");
        System.out.println("  -m --manifest [mf]\t Adds a specified manifest to");
        System.out.println("            \t\t the generated jar file.");
        System.out.println("  -e --error\t\t Show errors, meaning classes that could");
        System.out.println("            \t\t not be resolved and the classes that referenced them.");
        System.out.println("  -f --file [FILE]\t Class files are read from a text file");
        System.out.println("           \t\t instead of the command line");
        System.out.println("  -l --log\t\t Show classes as they are processed.");
        System.out.println("           \t\t This will include doubles, java classes");
        System.out.println("           \t\t and is difficult to read. You can use");
        System.out.println("           \t\t it as a sort of progress monitor");
        System.out.println("  -s --show\t\t Print all the classes that were packaged");
        System.out.println("           \t\t in alphabetical order, which is ordered");
        System.out.println("           \t\t by package for the most part.");
        System.out.println("  -h --help\t\t Display this help and exit");
        System.out.println("\n Authors: Torsten Rueger, Jerome Picault");
        System.out.println(" Report bugs to: Jerome.Picault@motorola.com");
    }

    void parseClass(String string) throws IOException {
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        string = string.replace('.', '/');
        JavaClass javaClass = new ClassParser(this.classPath.getInputStream(string), string).parse();
        this.addDependents(javaClass);
        System.out.println("Packaging for class: " + string);
    }

    public void execute(String[] stringArray) throws IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Manifest manifest = new Manifest();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-e") || stringArray[n].equals("--error")) {
                this.showNotFound = true;
            } else if (stringArray[n].equals("-s") || stringArray[n].equals("--show")) {
                this.printClasses = true;
            } else if (stringArray[n].equals("-l") || stringArray[n].equals("--log")) {
                this.log = true;
            } else if (stringArray[n].equals("-d") || stringArray[n].equals("--dest")) {
                if (n < stringArray.length - 1) {
                    defaultJar = stringArray[++n];
                }
            } else if (stringArray[n].equals("-m") || stringArray[n].equals("--manifest")) {
                if (n < stringArray.length - 1) {
                    manifest = new Manifest(new FileInputStream(stringArray[++n]));
                }
            } else if (stringArray[n].equals("-f") || stringArray[n].equals("--file")) {
                if (n < stringArray.length - 1) {
                    object3 = stringArray[++n];
                    System.out.println("Using this configuration file: " + (String)object3);
                    object2 = new BufferedReader(new FileReader((String)object3));
                    object = ((BufferedReader)object2).readLine();
                    while (object != null) {
                        this.parseClass(((String)object).trim());
                        object = ((BufferedReader)object2).readLine();
                    }
                    ((BufferedReader)object2).close();
                } else {
                    System.err.println("Error: no file specified\n");
                }
            } else {
                this.parseClass(stringArray[n]);
            }
            ++n;
        }
        if (this.dependents.isEmpty()) {
            this.usage();
            return;
        }
        System.out.println("Creating jar file: " + defaultJar);
        while (!this.dependents.isEmpty()) {
            object3 = (String)this.dependents.firstKey();
            object2 = (String)this.dependents.remove(object3);
            if (this.allClasses.get(object3) != null) continue;
            try {
                object = this.classPath.getInputStream((String)object3);
                JavaClass javaClass = new ClassParser((InputStream)object, (String)object3).parse();
                this.addDependents(javaClass);
            }
            catch (IOException iOException) {
                this.notFound.put(object3, object2);
            }
        }
        if (this.printClasses) {
            this.printAllClasses();
        }
        object3 = new JarOutputStream((OutputStream)new FileOutputStream(defaultJar), manifest);
        ((ZipOutputStream)object3).setLevel(9);
        object2 = this.allClasses.keySet().iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            string = (String)object2.next();
            JavaClass javaClass = (JavaClass)this.allClasses.get(string);
            ZipEntry zipEntry = new ZipEntry(string + ".class");
            byte[] byArray = javaClass.getBytes();
            int n3 = byArray.length;
            ((JarOutputStream)object3).putNextEntry(zipEntry);
            ((ZipOutputStream)object3).write(byArray, 0, n3);
            n2 += n3;
        }
        ((ZipOutputStream)object3).close();
        System.err.println("The jar file contains " + this.allClasses.size() + " classes and contains " + n2 + " bytes");
        if (!this.notFound.isEmpty()) {
            System.err.println(this.notFound.size() + " classes could not be found");
            if (this.showNotFound) {
                while (!this.notFound.isEmpty()) {
                    string = (String)this.notFound.firstKey();
                    System.err.println(string + " (" + this.notFound.remove(string) + ")");
                }
            } else {
                System.err.println("Use '-e' option to view classes that were not found");
            }
        }
    }

    void printAllClasses() {
        ArrayList arrayList = new ArrayList(this.allClasses.keySet());
        Collections.sort(arrayList);
        int n = 0;
        while (n < arrayList.size()) {
            String string = (String)arrayList.get(n);
            System.err.println(string);
            ++n;
        }
    }

    void addDependents(JavaClass javaClass) throws IOException {
        String string = javaClass.getClassName().replace('.', '/');
        this.allClasses.put(string, javaClass);
        ConstantPool constantPool = javaClass.getConstantPool();
        int n = 1;
        while (n < constantPool.getLength()) {
            Constant constant = constantPool.getConstant(n);
            if (constant != null && constant.getTag() == 7) {
                int n2 = ((ConstantClass)constantPool.getConstant(n)).getNameIndex();
                String string2 = ((ConstantUtf8)constantPool.getConstant(n2)).getBytes();
                this.addClassString(string2, string);
            }
            ++n;
        }
    }

    void addClassString(String string, String string2) throws IOException {
        if (this.log) {
            System.out.println("processing: " + string + " referenced by " + string2);
        }
        if (string.startsWith("[")) {
            if (string.length() == 2) {
                return;
            }
            if ('L' == string.charAt(1)) {
                this.addClassString(string.substring(2, string.length() - 1), string2);
                return;
            }
            if ('[' == string.charAt(1)) {
                this.addClassString(string.substring(1), string2);
                return;
            }
            throw new IOException("Can't recognize class name =" + string);
        }
        if (!string.startsWith("java/") && this.allClasses.get(string) == null) {
            this.dependents.put(string, string2);
        }
    }
}

