;;; -*- Mode:Lisp; Package:DYPAR; -*-


;;; --------------------------------------------------------
;;;
;;;	Copyright (c) by Jesus Gonzalez Boticario
;;;	              para Rank Xerox Espana S.A.
;;; 		
;;;		Septiembre de 1989
;;;
;;; --------------------------------------------------------

;;; Fichero para definir una portada para una aplicacion del interfaz
;;; de lenguaje natural Dypar.

(proclaim '(special *pant-portada*))

(defun def-pant-portada ()
  (defvar *pant-portada* (make-window-stream :height 28
			    	      :width 80
		                      :attribute 56)))
(defun pinta-pant-portada ()
  (send *pant-portada* :clear-screen)
  (dotimes (lin 25)
     (if (= lin 0)
         (progn
           (dotimes (col 78)           
               (send *pant-portada* :set-cursorpos (+ col 1) 0)
               (send *pant-portada* :write-string ""))
           (send *pant-portada* :set-cursorpos 0 lin)
           (send *pant-portada* :write-string "")
           (send *pant-portada* :set-cursorpos 79 lin)

           (send *pant-portada* :write-string ""))
         (if (< lin 24)
             (progn
               (send *pant-portada* :set-cursorpos 0 lin)
               (send *pant-portada* :write-string "")
               (send *pant-portada* :set-cursorpos 79 lin)
               (send *pant-portada* :write-string ""))
             (progn 			;si es la ultima linea
               (dotimes (col 78)           
                  (send *pant-portada* :set-cursorpos (+ col 1) lin)
                  (send *pant-portada* :write-string ""))
               (send *pant-portada* :set-cursorpos 0 lin)
               (send *pant-portada* :write-string "")
               (send *pant-portada* :set-cursorpos 79 lin)
               (send *pant-portada* :write-string "")))))

  (send *pant-portada* :set-cursorpos 18 09)
  (send *pant-portada* :write-string "APLICACION DEL INTERPRETE DE LENGUAJE NATURAL")
  (send *pant-portada* :set-cursorpos 18 10)
  (send *pant-portada* :write-string "")
  (send *pant-portada* :set-cursorpos 35 12)
  (send *pant-portada* :write-string "DYPAR")
  (send *pant-portada* :set-cursorpos 35 13)
  (send *pant-portada* :write-string "")
  (send *pant-portada* :set-cursorpos 20 18)
  (send *pant-portada* :write-string " Espere unos instantes, por favor ..."))

(def-pant-portada)
(pinta-pant-portada)

