;;; -*- Mode:Lisp; Package:DYPAR; Base:10; -*-

;;;          LastEditDate 14:00:00 We, 05-Aug-89  -- Jesus Gonzalez Boticario

;;; MAKE.LSP

;;; ----------------------------------------------------------------
;;;
;;; 		(c) Copyright, 1989,
;;; 			by Mark Boggs and
;;;                     Jesus Gonzalez Boticario 
;;;                     para Rank Xerox Espaa
;;; 			All rights reserved
;;;
;;; ----------------------------------------------------------------

; This file recompiles dypar where necessary when loaded into a lisp image

; Usage:
;  Connect to the directory in which the dypar files reside.
;  Load this file.

;;; Fix to make this compile properly on an 1186

(defvar **compile-ext** ".f2s")

(if (not (find-package "GCLISP"))
    (progn (setq **compile-ext** ".dfasl")
	   (make-package "GCLISP"))
    (setq **compile-ext** ".f2s"))


(in-package "DYPAR" :use '("LISP" "USER" "GCLISP"))

(defvar *dypar-load* nil)

;(if (y-or-n-p "~&Load the files? ")
    (setq *dypar-load* t)
;    (setq *dypar-load* nil))

(defun compile-changed-file (file-root &key (load nil))
  (let ((source (concatenate 'string file-root ".lsp"))
	(fasl (concatenate 'string file-root **compile-ext**)))
    (if (or (not (probe-file fasl))
	    (> (file-write-date source)
	       (file-write-date fasl)))
	(progn (compile-file source :load (and *dypar-load* load)) t)
        (progn (format t "~&~S is up to date~&" file-root)
	       (if (and *dypar-load* load) (load fasl))
	       nil))))

(defun compile-dependent-file (file-root load &rest dependent-files)
  (let ((source (concatenate 'string file-root ".lsp"))
	(fasl (concatenate 'string file-root **compile-ext**)))
    (if (or (not (probe-file fasl))
	    (> (file-write-date source)
	       (file-write-date fasl)))
	(progn (compile-file source :load (and *dypar-load* load)) t)
        (if (< (file-write-date fasl)
	       (apply #'max (mapcar #'file-write-date dependent-files)))
	    (progn (compile-file source :load (and *dypar-load* load)) t)
	    (progn (format t "~&~S is up to date~&" file-root)
		   (if (and *dypar-load* load) (load fasl))
		   nil)))))

(compile-changed-file "macros" :load t)
; We want the macros around at compile time for the other files.

; More general purpose files or files with data that is shared.
(compile-dependent-file "struc" t "macros.lsp")
(compile-dependent-file "general" t "macros.lsp" "struc.lsp")
(compile-dependent-file "var" t "macros.lsp")

; Multi-language message facility
(compile-changed-file "babel" :load t)

; Parser modules.
(compile-dependent-file "xload" t "macros.lsp" "struc.lsp" "babel.lsp")
(compile-dependent-file "xref" t "macros.lsp" "struc.lsp" "babel.lsp")
(compile-dependent-file "optimize" t "macros.lsp" "struc.lsp")
;(compile-dependent-file "flyxref" t "macros.lsp" "struc.lsp" "xref.lsp")

(compile-dependent-file "xmatch6" t "macros.lsp" "struc.lsp")
(compile-dependent-file "extend" t "macros.lsp" "struc.lsp")
(compile-changed-file "dyread" :load t)
(compile-dependent-file "xpar" t "macros.lsp" "struc.lsp" "babel.lsp")

(compile-dependent-file "dytest" t "macros" "struc" "babel")

;;; The new stuff.
(compile-changed-file "decl" :load t)
;;; Nuevos ficheros aadidos al sistema inicial
(compile-dependent-file "runtime" t "macros.lsp" "struc.lsp")
(compile-changed-file "elipsis" :load t)
(compile-changed-file "orto" :load t)
(compile-changed-file "conexion" :load t)
(compile-changed-file "grafic" :load t)
(compile-changed-file "dypartra" :load t)

(if (probe-file "dyparini.lsp")
    (and *dypar-load* (load "dyparini.lsp")))

;;; Sample application
;(if (y-or-n-p "Load the Semantic Network?")
;(timed-y-or-n-p "Load the Semantic Network?" :time-limit 15 :default nil)
;    (progn (compile-dependent-file "net" t "macros.lsp" "struc.lsp")
;	   (compile-dependent-file "singular" t "macros.lsp" "struc.lsp")))


;;; Since we use this file to load Dypar we might as well make sure that
;;; we get some important symbols imported into our package.
