;;; -*- Mode:Lisp; Package:DYPAR; Base:10; -*-

;;; fichero que contiene algunas funciones para investigar
;;; el estado de variables y de tablas hash creadas por
;;; Dypar.

;;; --------------------------------------------------------
;;;
;;;	Copyright (c) by Jesus Gonzalez Boticario
;;;	              en Rank Xerox Espana S.A.
;;; 		
;;;		Junio de 1989
;;;
;;; --------------------------------------------------------


;;; Trabajar en el paquete DYPAR
(in-package :dypar); :use '(:lisp :user :gclisp))

;;; funcion para recorrer la tabla hash referenciada por la variable
;;; *dypar-structure-hash* y la variable *dypar-terminal-hash*

(proclaim '(special *dypar-structure-hash* 
		    *dypar-terminal-hash*))

(defun recorre-tabla (&key (tabla *dypar-structure-hash* flag)
			   (busca nil))
  (if(not flag) (do ((resp))
		    ((or (eql resp #\S)
			 (eql resp #\N))
		     (and (eql resp #\S)
			  (setq tabla *dypar-terminal-hash*)))
		  (format t
		"~2% Escriba s si quiere investigar los terminales o ~%")
		  (format t " n si quiere los no-terminales ? ")
		  (setq resp (char-upcase (read-char)))))
  (if busca	
      (do ((continuar busca (y-or-n-p "~% Desea buscar otro simbolo "))
	   (clave)
	   (valor))
	  ((null continuar) (terpri))
	(format t
		"~2% Nombre del simbolo: ? " )
	(setq clave (read-from-string (read-line)))
	(setq valor (gethash clave tabla))
	(if valor
	    (format t "~%~S " (gethash clave tabla))
	  (format t "~2% No se ha encontrado el simbolo ~S ~%" clave)))
    (catch 'salir
      (let ((simbolos))
	(maphash (function (lambda (clave valor)
			     (declare (ignore valor))
			   (push clave simbolos)
			   (terpri)
			   (format t "~2%~S" (gethash clave tabla))
			   (terpri)
			   (format t 
				   "! Pulse <ENTER> para terminar ~
				   ~% cualquier otra tecla para continuar ! ")
			   (if (eql (char-upcase (read-char)) #\Newline)
			       (throw 'salir 
				 (progn (format t "~2%"))))))
		 tabla)
	(format t "~2%Los simbolos encontrados son:~% ~S ~%" 
		(nreverse simbolos)))))
  (values))

(defvar *dypartra-loaded* t)