;;; -*- Mode:Lisp; Package:DYPAR; Base:10; -*-

;;; DECL.LSP

;;; ----------------------------------------------------------------
;;;
;;; 		(c) Copyright, 1989,
;;; 			by Mark Boggs and
;;;                     Jesus Gonzalez Boticario 
;;;                     para Rank Xerox Espaa
;;; 			All rights reserved
;;;
;;; ----------------------------------------------------------------

;;; HISTORY
; 23-Feb-01 Moises Gil&Nuria Ripoll
;	Cambiamos de nombe la funcion "erase-gra" por "erasegra"
;
; En-01 Nuria Ripoll
;	Aado la funcion string-to-list a las exportadas por el paquete dypar.
;
; 08-Feb-89  Mark Boggs (boggs) at Rank Xerox, Spain
;	Created.

;;; This file contains function declarations used in the Dypar-I system.
;;; They are intended to be included in the compile environment of the
;;; system.  The declarations are useful if the individual source files
;;; include the line: "(proclaim '(optimize (speed 3)))"
;;; 

(in-package "DYPAR"); :use '("LISP" "USER"))

;;; Defined in XMATCH
(proclaim '(function smatch (list t symbol symbol list integer) list))
(proclaim '(function smatch1 (list t symbol symbol list integer) list))
(proclaim '(function smatch-pr (list t symbol symbol list integer) list))
(proclaim '(function progress (list list) list))
(proclaim '(function xmatch (list list) list))
(proclaim '(function best-match (list list) list))
(proclaim '(function newvars (list) list))

;;; Defined in EXTEND
(proclaim '(function mapinto (list list list symbol symbol list integer) list))

;;; Defined in GENERAL
(proclaim '(function intersectp (list list) symbol))
(proclaim '(function flatten (list) list))
(proclaim '(function filter (list list) list))
(proclaim '(function prelist (list integer) list))
(proclaim '(function subset (function list) list))
(proclaim '(function uci-every (function list) symbol))
(proclaim '(function setdiff (list list) list))
(proclaim '(function set-diff (list list) list))

;;; The symbols we wish to export to the user package are listed below.
;;; se ha incluido el simbolo "interfaz" ademas de corregir el error de
;;; no haber puesto "find-package".

;;; Nuria Ripoll.30-Enero

(export '(dypar::parser dypar::loadgra dypar::erasegra dypar::xmatch 
			dypar::access dypar::interfaz dypar::string-to-list) 
	(find-package :dypar))

(import '(dypar::parser dypar::loadgra dypar::erasegra dypar::xmatch 
			dypar::access dypar::interfaz dypar::string-to-list)
	(find-package :user))

(defvar *decl-loaded* t)