;*********************************************************************
; Mdulo: IERL
; Uso:    IAAA Experimental Representation Language
; Autor:  Roberto Sobreviela Ruiz
; email:  419245@cepsz.unizar.es
;         sobreviela@teleline.es
;*********************************************************************
; Fichero: IERL.lsp       Fecha Creacin: 31 de diciembre de 1999
; Versin: 0.0.1          Fecha Modificacin: 12 de enero del 2000
; Estado:  Desarrollo     Autor: Roberto Sobreviela Ruiz
;---------------------------------------------------------------------
; Uso: Integracin del lenguaje IERL.
; Comentarios:
; Historia:
;   Versin 0.0.1:  Comienzo de la integracin.
;*********************************************************************

(defun load-IERL-system ()
	(load "ierl Frame System.lsp")
	(load "ierl Pattern Matching.lsp")
	(load "ierl Streams.lsp")
	(load "ierl Rule Definition.lsp")
	(load "ierl Forward Chaining.lsp")
	(load "ierl Backward Chaining.lsp"))
	
(defun ejemplo-1 ()
	(setf *afirmaciones* 'flujo-vacio)
	(setf *reglas* 'flujo-vacio)
	(recuerda-afirmacion '(bobby es un perro))
	(recuerda-afirmacion '(deedee es un caballo))
	(recuerda-afirmacion '(deedee es padre de brassy))
	(recuerda-afirmacion '(deedee es padre de sugar))
	(recuerda-regla '(misma-especie
		((? padre) es un (? especie))
		((? padre) es padre de (? cria))
		((? cria) es un (? especie)))))

(defun ejemplo-2 ()
	(setf *afirmaciones* 'flujo-vacio)
	(setf *reglas* 'flujo-vacio)
	(recuerda-afirmacion '(robbie tiene manchas oscuras))
	(recuerda-afirmacion '(robbie tiene color leonado))
	(recuerda-afirmacion '(robbie come carne))
	(recuerda-afirmacion '(robbie tiene pelo))
	(recuerda-afirmacion '(suzie tiene plumas))
	(recuerda-afirmacion '(suzie vuela bien))
	(recuerda-regla '(es-mamifero
		((? animal) tiene pelo)
		((? animal) es mamifero)))
	(recuerda-regla '(es-ave
		((? animal) tiene plumas)
		((? animal) es ave)))
	(recuerda-regla '(es-carnivoro
		((? animal) come carne)
		((? animal) es carnivoro)))
	(recuerda-regla '(es-leopardo
		((? animal) es mamifero)
		((? animal) es carnivoro)
		((? animal) tiene color leonado)
		((? animal) tiene manchas oscuras)						
		((? animal) es leopardo)))
	(recuerda-regla '(es-albatros
		((? animal) es ave)
		((? animal) vuela bien)		
		((? animal) es albatros))))

(defun ejemplo-3 ()
	(setf *afirmaciones* 'flujo-vacio)
	(setf *reglas* 'flujo-vacio)
	(setf *frames* 'flujo-vacio)
	(setq *form-sensitive* t)
	
	(base-form 'XXX)
	(form :name 'YYY :is-a 'XXX)
	(form :name 'ZZZ :is-a 'XXX)
	(recuerda-afirmacion '(robbie tiene manchas oscuras))
	(recuerda-afirmacion '(robbie tiene color leonado))
	(recuerda-afirmacion '(robbie come carne))
	(recuerda-afirmacion '(robbie tiene pelo))
	(recuerda-afirmacion '(suzie tiene plumas))
	(recuerda-afirmacion '(suzie vuela bien))
	(recuerda-regla '(es-mamifero
		((? animal) tiene pelo)
		((? animal) es mamifero)))
	(recuerda-regla '(es-ave
		((? animal) tiene plumas)
		((? animal) es ave)))
	(recuerda-regla '(es-carnivoro
		((? animal) come carne)
		((? animal) es carnivoro)))
	(recuerda-regla '(es-leopardo
		((? animal) es mamifero)
		((? animal) es carnivoro)
		((? animal) tiene color leonado)
		((? animal) tiene manchas oscuras)						
		((? animal) es leopardo)))
	(recuerda-regla '(es-albatros
		((? animal) es ave)
		((? animal) vuela bien)		
		((? animal) es albatros)))
	(recuerda-regla '(identifica-frame
		((objeto obj))
		((objeto obj) es un frame)))
	(recuerda-regla '(identifica-frame-XXX
		((objeto obj (es XXX)))
		(el frame (objeto obj) es de tipo XXX)))
	(recuerda-regla '(identifica-frame-YYY
		((objeto obj (es YYY)))
		(el frame (objeto obj) es de tipo YYY)))
	(recuerda-regla '(identifica-frame-ZZZ
		((objeto obj (es ZZZ)))
		(el frame (objeto obj) es de tipo ZZZ))))

(defun ejemplo-4 ()
	(setf *afirmaciones* 'flujo-vacio)
	(setf *reglas* 'flujo-vacio)
	(setf *frames* 'flujo-vacio)
	(setq *form-sensitive* t)
	
	(base-form 'XXX)
	(form :name 'YYY :is-a 'XXX)
	(form :name 'ZZZ :is-a 'XXX)
	(recuerda-regla '(identifica-frame
		((objeto obj))
		((objeto obj) es un frame)))
	(recuerda-regla '(identifica-frame-XXX
		((objeto obj (es XXX)))
		(el frame (objeto obj) es de tipo XXX)))
	(recuerda-regla '(identifica-frame-YYY
		((objeto obj (es YYY)))
		(el frame (objeto obj) es de tipo YYY)))
	(recuerda-regla '(identifica-frame-ZZZ
		((objeto obj (es ZZZ)))
		(el frame (objeto obj) es de tipo ZZZ))))
